<?php
get_header(); ?>
    <div class="wrap">
        <div id="primary" class="content-area">
            <main id="main" class="site-main">
                <?php if (get_theme_mod('osf_page_404_page_enable') != 'default' && !empty(get_theme_mod('osf_page_404_page_custom'))): ?>
                    <?php $query = new WP_Query('page_id=' . get_theme_mod('osf_page_404_page_custom'));
                    if ($query->have_posts()):
                        while ($query->have_posts()) : $query->the_post();
                            the_content();
                        endwhile;
                    endif; ?>
                <?php else: ?>
                    <section class="error-404 not-found">
                        <div class="page-content">
                            <img src="<?php echo get_theme_file_uri('assets/images/404.png') ?>">
                            <div class="error-text">
                                <?php esc_html_e('Page doesn’t exist or some other error occured. Go to our', 'co-workshop'); ?>
                                <br>
                                <a href="<?php echo esc_url(home_url('/')); ?>" class="return-homepage"><?php esc_html_e('Home page', 'co-workshop'); ?></a>
                                <?php esc_html_e('or go back to', 'co-workshop'); ?>
                                <a href="javascript: history.go(-1)" class="go-back"><?php esc_html_e('Previous page', 'co-workshop'); ?></a>
                            </div>
                        </div>
                    </section><!-- .error-404 -->
                <?php endif; ?>
            </main><!-- #main -->
        </div><!-- #primary -->
    </div><!-- .wrap -->

<?php get_footer();
