<?php
if (!defined('ABSPATH')) {
    exit;
}

if (has_post_thumbnail()) {
    $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'co-workshop-featured-image-small');
} else {
    $thumbnail_url = co_workshop_get_placeholder_image();
}
?>
<article <?php post_class('osf-event-article'); ?>>
    <div class="post-inner row">
        <div class="post-thumbnail col-lg-4 col-md-12">
            <div class="entry-meta">
                <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_date'))): ?>
                    <span class="entry-date"><?php echo sprintf('<time class="entry-date" datetime="%1$s">%2$s</time>',
                            date(DATE_W3C, osf_get_metabox(get_the_ID(), 'osf_event_date')),
                            date('d M', osf_get_metabox(get_the_ID(), 'osf_event_date'))
                        );
                        ?></span>
                <?php endif; ?>

            </div>
            <a href="<?php the_permalink(); ?>">
                <img src="<?php echo esc_url($thumbnail_url); ?>" alt="<?php echo esc_attr(get_the_title()) ?>">
            </a>
        </div><!-- .post-thumbnail -->

        <div class="entry-content col-lg-5 col-md-8 col-sm-12">
            <header class="entry-header">

                <div class="cat-links">
                    <?php the_terms(get_the_ID(), 'osf_event_category', '', ' ', ''); ?>
                </div>
                <?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>

            </header><!-- .entry-header -->
            <p class="description"><?php echo co_workshop_get_excerpt(25); ?></p>
        </div>
        <div class="link-more col-lg-3 col-md-4 col-sm-12"><a
                    href="<?php the_permalink(); ?>"><?php esc_html_e('More Info', 'co-workshop'); ?></a></div>
    </div>
</article><!-- #post-## -->

